﻿/*  Author:     Ben Hall
 *  File:       Armor.cs
 *  Date:       4/28/2011
 *  
 *  Purpose:    Armor.cs extends the Equipment class and is used to represent Equipment that
 *              adds an armor value to the PlayerCharacter.  Each piece of armor may have one
 *              ArmorType (Body or Shield) representing equipment slots that the PlayerCharacter
 *              has.
 *              
 *              The class only containts a constructor, and get methods for its variables.
 */

using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace OnlineGame
{
    public enum ArmorType
    {
        Body,
        Shield
    }

    public class Armor : Equipment
    {
        private float protectionValue;
        private ArmorType armorType;

        public Armor(String armorNameIn, int armorValueIn, float protectionValueIn, ArmorType armorTypeIn)
        {
            this.itemName = armorNameIn;
            this.itemValue = armorValueIn;
            this.protectionValue = protectionValueIn;
            this.armorType = armorTypeIn;
        }

        public float GetProtectionValue()
        {
            return this.protectionValue;
        }

        public ArmorType GetArmorType()
        {
            return this.armorType;
        }
    }
}
